﻿using System.Collections.Generic;

namespace PolymorphicCollections
{
    class Program
    {
        static void Main(string[] args)
        {
            string[] fromArray = AddNumbers(new string[] { "A", "B", "C" });
            List<string> list = new List<string> { "A", "B", "C" };
            string[] fromList = AddNumbers(list);
        }

        // Listing 7-30. Stosowanie interfejsów IEnumerable<T> oraz IEnumerator<T>.
        static string[] AddNumbers(IEnumerable<string> names)
        {
            List<string> numberedNames = new List<string>();
            using (IEnumerator<string> enumerator = names.GetEnumerator())
            {
                int i = 0;
                while (enumerator.MoveNext())
                {
                    string currentName = enumerator.Current;
                    numberedNames.Add(string.Format("{0}. {1}", i, currentName));
                    i += 1;
                }
            }
            return numberedNames.ToArray();
        }
    }

    class ForEachExample
    {
        // Listing 7-31. Zastosowanie intefejsu IEnumerable<T> w pętli foreach
        static string[] AddNumbers(IEnumerable<string> names)
        {
            List<string> numberedNames = new List<string>();
            int i = 0;
            foreach (string currentName in names)
            {
                numberedNames.Add(string.Format("{0}. {1}", i, currentName));
                i += 1;
            }
            return numberedNames.ToArray();
        }
    }

    class EnumerableExample
    {
        // Listing 7-32. Implementacja interfejsu IEnumerable<T> przy użyciu typu wytwarzanego.
        static IEnumerable<string> AddNumbers(IEnumerable<string> names)
        {
            int i = 0;
            foreach (string currentName in names)
            {
                yield return string.Format("{0}. {1}", i, currentName);
                i += 1;
            }
        }
    }
}
